<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class AddToggleToEnableRegistrationToEvents extends Migration
{
    public function up(): void
    {
        if (! InsideSchema::isContentType('events')) {
            return;
        }

        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'events',
            'registration_enabled',
            [
                'name' => 'display_hours',
                'searchable' => false,
                'translatable' => false,
                'default' => true,
                'required' => false,
                'weight' => 15,
                'title' => [
                    'fr' => 'Activer l\'inscription aux événements',
                    'en' => 'Enable event registration',
                    'es' => 'Activar la inscripción en eventos',
                    'de' => 'Aktivieren Sie die Anmeldung für Veranstaltungen',
                    'pt' => 'Activar o registo do evento',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            15
        );
    }
}
