<?php

declare(strict_types=1);

use Drupal\Core\Entity\EntityStorageException;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Log;
use Inside\Content\Contracts\SchemaService;
use Inside\Host\Migrations\CreateContentTypes;

final class FixShortcuts extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $schemaService = App::make(SchemaService::class);
        if (! $schemaService->hasContentType('tools')) {
            return;
        }
        if (! $schemaService->hasField('users', 'tools')) {
            return;
        }
        $fieldOptions = $schemaService->getFieldOptions('users', 'tools');

        if (array_key_exists('editable', $fieldOptions) && $fieldOptions['editable'] === true) {
            return;
        }

        try {
            $this->getConsole()->write('Rendre éditable le champ <fg=cyan>tools</fg=cyan> pour les utilisateurs');
            $this->getBridge()?->updateFieldOptions(
                'users',
                'tools',
                [
                    'editable' => true,
                ]
            );
            $this->writeResult(true);
        } catch (EntityStorageException|Exception $exception) {
            Log::error(__(
                'Migration "FixShortcuts" failed => :message',
                [
                    'message' => $exception->getMessage(),
                ]
            ));
            $this->writeResult(false);
        }

        $this->finishUp();
    }
}
