<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class UpdateFieldDateEventsSearchable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        if (
            Schema::hasModel('events')
            && Schema::hasField('events', 'date')
        ) {
            $bridge->updateFieldOptions('events', 'date', ['search_result_field' => true]);
        }
    }
}
