<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddOpenToNewTabFieldToCta extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateField(
            'call_to_action',
            'open_in_new_tab',
            [
                'name' => 'open_in_new_tab',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Ouverture dans un nouvel onglet',
                    'en' => 'Open in a new tab',
                    'de' => 'In einem neuen Tab öffnen',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 5,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ],
            4,
            'paragraph'
        );
    }

    public function down(): void
    {
    }
}
