<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

final class InitRevisions extends Migration
{
    public function up(): void
    {
        Schema::table(
            'inside_revisions',
            function (Blueprint $table) {
                $table->unique(['contentable_type', 'contentable_id', 'version']);
                $table->index(['locale', 'contentable_type', 'contentable_id']);
            }
        );
    }
}
