<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Models\Revision;

final class AddUserToInsideRevisionsTable extends Migration
{
    public function up(): void
    {
        Schema::table(
            'inside_revisions',
            function (Blueprint $table) {
                $table->uuid('user_id')->nullable()->after('contentable_id');
            }
        );
        Revision::each(fn (Revision $revision) => $revision->update(['user_id' => $revision->content->modificator?->uuid]));
    }
}
