<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class AddCustomSlugFieldToPersosContentType extends Migration
{
    public function up(): void
    {
        if (! Schema::hasContentType('custom')) {
            return;
        }
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'custom',
            'custom_slug',
            [
                'type'                => BridgeContentType::TEXT_FIELD,
                'name'                => 'custom_slug',
                'searchable'          => false,
                'translatable'        => false,
                'search_result_field' => false,
                'required'            => false,
                'title'               => [
                    'fr' => 'Custom slug',
                ],
                'description'         => [
                    'fr' => '',
                ],
                'settings'            => [
                    'cardinality' => 1,
                ],
                'widget'              => [
                    'type'     => BridgeContentType::TEXT_WIDGET,
                    'settings' => [],
                    'weight'   => 1,
                ],
            ]
        );
    }
}
