<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RemoveFieldsFromSectionFile extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $fields = ['titre', 'file_title'];

        foreach ($fields as $field) {
            if (Schema::hasColumn('inside_section_file', $field)) {
                Schema::table('inside_section_file', function (Blueprint $table) use ($field) {
                    $table->dropColumn($field);
                });
            }
        }
    }
}
