<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\DynamicClass;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

class CreateButtonSectionType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        DynamicClass::disableRebuildAutoLoad();
        $this->bootUp(__FILE__, 'Button section type');

        $this->migrateContent('button', false, 'sections');
        $this->getConsole()->writeln('<info>Ajout du nouveau type de paragraph</info>');

        $this->finishUp();
        DynamicClass::enableRebuildAutoLoad();
        $this->call('models:rebuild');
    }

    public function down(): void
    {
        $this->bootDown(__FILE__);
        $this->finishDown();
    }
}
