<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInsideChatsTable extends Migration
{
    public function up(): void
    {
        Schema::create(
            'inside_chats',
            function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->uuid('user_uuid');
                $table->text('message');
                $table->timestamps();
            }
        );
        Schema::table(
            'inside_chats',
            function (Blueprint $table) {
                $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
            }
        );
    }

    public function down(): void
    {
        Schema::table(
            'inside_chats',
            function (Blueprint $table) {
                $table->dropForeign('inside_chats_user_uuid_foreign');
            }
        );
        Schema::dropIfExists('inside_chats');
    }
}
