<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AddUniqueIndexOnPivotsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        /**
         * ALTER IGNORE TABLE `inside_pivots`
         * ADD UNIQUE `parent_type_parent_uuid_related_type_related_uuid` (`parent_type`, `parent_uuid`, `related_type`, `related_uuid`);
         */
        $pivots = DB::table('inside_pivots')->get();
        $uniques = [];
        $duplicates = [];

        // Find duplicates
        foreach ($pivots as $pivot) {
            $key = $pivot->parent_type.'-'.$pivot->parent_uuid.'-'.$pivot->related_type.'-'
                .$pivot->related_uuid.'-'.$pivot->related_field;
            if (in_array($key, $uniques)) {
                $duplicates[] = $pivot->id;
            } else {
                $uniques[] = $key;
            }
        }

        // Delete duplicates
        foreach (array_chunk($duplicates, 1000) as $data) {
            DB::table('inside_pivots')->whereIn('id', $data)->delete();
        }

        Schema::table('inside_pivots', function (Blueprint $table) {
            $table->unique(['parent_type', 'parent_uuid', 'related_type', 'related_uuid', 'related_field'], 'parent_type_parent_uuid_related_type_related_uuid');
        });
    }
}
