<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Facades\Schema as InsideSchema;

class FixPidColumn extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $contentTypes = InsideSchema::getContentTypes();
        foreach ($contentTypes as $contentType) {
            if (Schema::hasColumn((string) type_to_table($contentType), 'pid')) {
                Schema::table((string) type_to_table($contentType), function (Blueprint $table) {
                    $table->string('pid')->nullable()->default(null)->change();
                });
                $query = call_user_func(type_to_class($contentType).'::query');
                $query->where('pid', '')->update(['pid' => null]);
            }
        }
    }
}
