<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Helpers\SchemaHelper;
use Inside\Content\Models\Model;
use Inside\Host\Bridge\BridgeContent;

/**
 * Class FixFilePath
 * @deprecated to be removed
 */
class FixFilePath extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        // Get fresh model classes & infos
        Artisan::call('models:rebuild');

        Inside\Facades\Inside::withoutDrupalModule(function () {
            // Get models with field file
            $models = Model::whereHas('fields', function ($query) {
                return $query->where('inside_fields.type', 'file');
            })->each(function ($model) {
                // Foreach fields
                $model->fields()->whereIn('type', ['file', 'image'])->pluck('name')->each(function ($field) use ($model) {
                    $query = call_user_func($model->class.'::query');
                    $query->where($field, 'like', '% %')
                       // Foreach items
                   ->each(function ($item) use ($model, $field) {
                       // Load drupal entity

                       if (strstr($model->class, 'Inside\Content\Models\Sections\\')) {
                           $entity = Drupal::service('entity.manager')->loadEntityByUuid('paragraph', $item->uuid_host);
                       } else {
                           $entity = Drupal::service('entity.manager')->loadEntityByUuid('node', $item->uuid_host);
                       }

                       if (! $entity) {
                           return;
                       }

                       // Get file storage
                       $file = Drupal::service('entity.manager')->getStorage('file')->load($entity->{'field_'.$field}->target_id);

                       $destination = str_replace(' ', '-', $file->uri->value);

                       // Move file to correct name without space
                       if ($file && ($file = file_move($file, $destination)) !== false) {
                           // Save new file path
                           $entity->save();

                           // Disable model event dispatcher
                           call_user_func($model->class.'::unsetEventDispatcher');

                           // Get file path the same way we get it in our normmalizer
                           $path = urldecode(file_url_transform_relative(file_create_url($file->getFileUri())));

                           $path = trim(str_replace(
                               [
                                   storage_path('app'),
                                   config('app.app_storage_path', storage_path('app')),
                                   'vendor/maecia/inside/',
                                   ':',
                                   './',
                               ],
                               [
                                   '',
                                   '',
                                   '',
                                   '',
                                   '/',
                               ],
                               $path
                           ), '/');

                           // Save inside side has we don't have event to save it
                           $item->{$field} = $path;
                           $item->save();
                       }
                   });
                });
            });
        });

        // We need to clear cache no dispatcher to auto clear it
        Artisan::call('cache:clear');
    }
}
