<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

class CreateImageOptimisationContents extends Migration
{
    use CreateContentTypes;

    protected array $styles = [
        [
            'title'                    => 'thumbnail',
            'field_width'              => 80,
            'field_height'             => 60,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
        ],
        [
            'title'                    => 'small',
            'field_width'              => 350,
            'field_height'             => 230,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
        ],
        [
            'title'                    => 'medium',
            'field_width'              => 760,
            'field_height'             => 450,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
        ],
        [
            'title'                    => 'big',
            'field_width'              => 1400,
            'field_height'             => 680,
            'field_optimisation'       => true,
            'field_optimisation_ratio' => 80,
        ],
    ];

    public function up(): void
    {
        $imageStyle = DB::table('migrations')->where('migration', '2019_11_21_000000_create_image_optimisation_contents')->exists();
        if ($imageStyle) {
            return;
        }
        $this->bootUp(__FILE__, 'Image optimisation');
        $bridge = new BridgeContent();
        $langcode = config('app.locale', 'fr');

        $this->getConsole()->writeln('Langue du site détecté : ['.$langcode.']');

        if (Schema::hasModel('image_style')) {
            // Wrong old content type to be deleted
            $this->getConsole()->writeln(
                "<info>Détection d'un type de contenu <class>image_style</class> obsolete</info>"
            );
            $this->getConsole()->writeln('<warning>Suppression des contenus <class>image_style</class></warning>');
            $toBeDeleted = call_user_func(type_to_class('image_style').'::get');
            foreach ($toBeDeleted as $content) {
                $this->getConsole()->writeln('<note>Suppression de <class>'.$content->title.'</class></note>');
                $bridge->contentDelete('image_style', $content->uuid);
            }
            $this->getConsole()->writeln(
                '<warning>Suppression du type de contenu <class>image_style</class></warning>'
            );

            $this->getBridge()?->contentTypeDelete('image_style');
            $this->getConsole()->writeln(
                "<info>Système nettoyé et prêt pour l'installation des nouveaux types de contenu</info>"
            );
        }

        $this->migrateContent('image_styles');
        $this->getConsole()->writeln('<info>Reconstruction des modèles de données Inside</info>');

        $author = Users::where('email', config('app.technical_mail'))->first();

        $this->getConsole()->writeln('<info>Installation des styles par défaut Inside 2</info>');
        // Create default image style
        foreach ($this->styles as $style) {
            $style['type'] = 'node';
            $style['bundle'] = 'image_styles';
            $style['langcode'] = $langcode;
            $style['author'] = $author->uuid;
            $this->getConsole()->writeln('<note>Ajout du style <class>'.$style['title'].'</class></note>');
            $bridge->contentInsert('image_styles', $style);
        }

        $this->finishUp();
    }

    public function down(): void
    {
        $this->bootDown(__FILE__);
        $this->finishDown();
    }
}
