<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Helpers\SchemaHelper;

class CreatePivotsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        if (! Schema::hasTable('inside_pivots')) {
            Schema::create('inside_pivots', function (Blueprint $table) {
                $table->increments('id');
                $table->uuid('parent_uuid')->collate('utf8');
                $table->uuid('related_uuid')->collate('utf8');
                $table->index(['parent_uuid', 'related_uuid']);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_pivots');

        $tables = SchemaHelper::listContentTables();

        foreach ($tables as $table) {
            Schema::dropIfExists($table);
        }
    }
}
