<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFieldsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('inside_fields', function (Blueprint $table) {
            $table->increments('id');
            $table->string('model', 255);
            $table->string('name', 255);
            $table->string('type', 255);
            $table->longText('options')->nullable();
            $table->unique(['model', 'name']);
            $table->index('model');
            $table->index('name');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_fields');
    }
}
