<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Inside\Host\Migrations\CreateContentTypes;

class AddAuthorIdColumnOnUsers extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $console = $this->getConsole();

        $type = 'users';
        $table = type_to_table($type);
        if (Schema::hasColumn((string) $table, 'author_id')) {
            $console->writeln('<note><fg=cyan>'.$type.
                '</> already has a <fg=magenta>author_id</> field!!!</>');

            return;
        }
        $console->writeln('<info>Adding author_id column to <fg=cyan>'.$type.'</></info>');

        // Add column
        Schema::table(
            (string) $table,
            function (Blueprint $table) {
                $table->uuid('author_id')->nullable()->after('author');
            }
        );

        // Copy author to author_id
        DB::table($table)->update(['author_id' => DB::raw('author')]);
        Schema::table(
            (string) $table,
            function (Blueprint $table) {
                $table->uuid('author_id')->nullable(false)->change();
            }
        );
        $this->finishUp();
    }

    public function down(): void
    {
    }
}
