<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'public_pages',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Page publique',
            'en' => 'Public page',
            'de' => 'Öffentliche Seite',
            'es' => 'Página pública',
            'pt' => 'Página pública',
        ],
    ],
    'fields' => [
        [
            'name' => 'content',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
                'de' => 'Inhalt',
                'es' => 'Contenido',
                'pt' => 'Conteúdo',
            ],
            'description' => [
                'fr' => 'Sélectionnez les différents types de paragraphes que vous voulez faire remonter sur la page',
                'en' => 'Select the different types of paragraphs you want to move up on the page',
                'de' => 'Wählen Sie die verschiedenen Absatztypen aus, die Sie auf der Seite nach oben bringen wollen',
                'es' => 'Seleccione los distintos tipos de párrafos que desea desplazar hacia arriba en la página',
                'pt' => 'Seleccione os diferentes tipos de parágrafos que deseja mover para cima da página',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'button',
                ],
                'cardinality' => -1,
            ],
        ],
    ],
];
