<?php

use Inside\Content\Jobs\CleanupWysiwygImages;

return [
    'schedule' => [
        'cleanup_uploads' => function ($scheduler) {
            // Cleanup old .part in chunks directory && unused uploaded files
            $scheduler->command('inside:uploads:clean')->daily()->at('0:00');
        },
        'cleanup_profile_images' => function ($scheduler) {
            $scheduler->command('inside:profile:image:clean')->daily()->at('1:00');
        },
        'cleanup_wysiwyg_images' => function ($scheduler) {
            $scheduler->job(new CleanupWysiwygImages(), get_low_priority_queue_name())->hourly();
        },
        'cleanup_revisions' => function ($scheduler) {
            $scheduler->command('inside:revision:clean')->daily()->at('20:00');
        },
    ],
];
