<?php

return [
    'test' => [
        'content_type' => 'news',
        'format' => [
            'driver' => 'csv',
        ],
        'fields'       => [
            'uuid' => 'ID',
            'title' => 'Titre',
            'image' => 'Image',
        ],
        'preFlight' => function ($console) {
        },
        'finishing'    => function ($record, Inside\Host\Bridge\BridgeContent $bridge, $uuid, $console = null) {
        },
        'key'          => [
            // Keys
            'import' => 'ID',
            'inside' => 'uuid',
        ],
    ],

    // Example
/**
    '<config_name>' => [
        'content_type' => '<content_type_name>',
        'format'       => [
            // Driver
            'type'    => 'csv',
            'options' => [
                'delimiter' => ';',
                'enclosure' => ' ',
                'escape'    => '\\',
                'offset'    => 0,
            ],
        ],
        'preFlight'    => function ($console) {
            // Preflight
            // For example, disable all content

            $console->info('Preflight done');
        },
        'fields'       => [
            '<field_from_import>' => '<field_in_inside>',
            '<field_from_import>'       => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                // Callback
            },
        ],
        'finishing'    => function ($record, \Inside\Host\Bridge\BridgeContent $bridge, $uuid, $console = null) {
            // After record is saved

            // For example, attach something
        },
        'key'          => [
            // Keys
            'import' => '<unique_key_field_in_import>',
            'inside' => '<unique_key_field_in_inside>',
        ],
        'postFlight'   => function ($console) {
            // After import
            $console->info('Postflight done');
        },
    ],
 */
];
