<?php

use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\BooleanField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\EntityReferenceField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\EntityReferenceRevisionsField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\FileField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\ImageField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\IntegerField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\StringField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\StringListField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\StringLongField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\TextLongField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\TextWithSummaryField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\TimestampField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\VideoField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage\BaseStorage;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage\BooleanStorage;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Paragraphs\ParagraphsTypeBundle;

return [
    /*
    |--------------------------------------------------------------------------
    | Paragraphs custom
    |--------------------------------------------------------------------------
    |
    | You can override in the back repository this configuration to add
    | your own cutsomized paragraphs.
    |
    */
    'custom' => [],

    /*
    |--------------------------------------------------------------------------
    | Deprecated Paragraphs
    |--------------------------------------------------------------------------
    |
    | These paragraphs are no longer supported by the new instances, so
    | they should no longer be installed and their configuration files
    | should only be generated if they are already present on the intranet.
    |
    */
    'deprecated' => [
        'document_cards' => [
            'label' => 'field.documents_selection.label',
            'fields' => [
                'field_title' => [
                    'class' => StringField::class,
                    'label' => 'field.title.label',
                    'required' => true,
                ],
                'field_document_card_documents' => [
                    'class' => EntityReferenceField::class,
                    'label' => 'field.documents.label',
                    'required' => true,
                    'target_type' => 'node',
                    'target_bundles' => [
                        'documents' => 'documents',
                    ],
                ],
            ],
        ],
        'updated_document_cards' => [
            'label' => 'field.last_published_documents.label',
            'fields' => [
                'field_title' => [
                    'class' => StringField::class,
                    'label' => 'field.title.label',
                    'required' => true,
                ],
                'field_updated_doc_card_folder' => [
                    'class' => EntityReferenceField::class,
                    'label' => 'field.folder.label',
                    'required' => true,
                    'target_type' => 'node',
                    'target_bundles' => [
                        'folders' => 'folders',
                    ],
                ],
            ],
        ],
        'user_cards' => [
            'label' => 'field.users_selection.label',
            'fields' => [
                'field_title' => [
                    'class' => StringField::class,
                    'label' => 'field.title.label',
                    'required' => true,
                ],
                'field_user_card_users' => [
                    'class' => EntityReferenceField::class,
                    'label' => 'field.users.label',
                    'required' => true,
                    'target_type' => 'user',
                ],
            ],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Specific Paragraphs
    |--------------------------------------------------------------------------
    |
    | These paragraphs are specific to the intranet. They are active by
    | default for new intranet, for the old they have to be sold to be active
    |
    */
    'specific' => [
        'slide_image' => [
            'label' => 'field.slide_image.label',
            'fields' => [
                'field_title' => [
                    'class' => StringField::class,
                    'label' => 'field.slide_image_legend.label',
                ],
                'field_image' => [
                    'class' => ImageField::class,
                    'label' => 'field.image.label',
                ],
            ],
        ],
        'slide_video' => [
            'label' => 'field.slide_video.label',
            'fields' => [
                'field_title' => [
                    'class' => StringField::class,
                    'label' => 'field.slide_video_legend.label',
                ],
                'field_file' => [
                    'class' => VideoField::class,
                    'label' => 'field.file.label',
                ],
            ],
        ],
        'advanced_table' => [
            'label' => 'field.advanced_table.label',
            'fields' => [
                'field_advanced_table' => [
                    'class' => StringLongField::class,
                    'label' => 'field.advanced_table.label',
                ],
            ],
        ],
        'fetched_contents' => [
            'label' => 'field.fetched_contents.label',
            'fields' => [
                'field_content_type' => [
                    'class' => StringField::class,
                    'label' => 'field.content_type.label',
                    'required' => true,
                ],
                'field_selection' => [
                    'class' => StringLongField::class,
                    'label' => 'field.content.label',
                ],
                'field_custom_order' => [
                    'class' => BooleanField::class,
                    'label' => 'field.custom_order.label',
                ],
                'field_fetch_link' => [
                    'class' => StringField::class,
                    'label' => 'field.link.label',
                ],
                'field_limit' => [
                    'class' => IntegerField::class,
                    'label' => 'field.limit.label',
                ],
                'field_link_label' => [
                    'class' => StringField::class,
                    'label' => 'field.link_label.label',
                ],
                'field_sort' => [
                    'class' => StringField::class,
                    'label' => 'field.order.label',
                ],
                'field_selection_type' => [
                    'class' => StringField::class,
                    'label' => 'field.selection.label',
                    'required' => true,
                ],
                'field_one_column_display' => [
                    'class' => BooleanField::class,
                    'label' => 'field.one_column_display.label',
                ],
                'field_show_pagination' => [
                    'class' => BooleanField::class,
                    'label' => 'field.show_pagination.label',
                ],
                'field_fetched_title' => [
                    'class' => StringField::class,
                    'label' => 'field.title.label',
                ],
            ],
        ],
        'slide' => [
            'label' => 'field.slide.label',
            'fields' => [
                'field_title' => [
                    'class' => StringField::class,
                    'label' => 'field.title.label',
                ],
                'field_image' => [
                    'class' => ImageField::class,
                    'label' => 'field.image.label',
                ],
            ],
        ],
        'slider' => [
            'label' => 'field.slider.label',
            'fields' => [
                'field_content' => [
                    'class' => EntityReferenceRevisionsField::class,
                    'label' => 'field.content.label',
                    'target_type' => ParagraphsTypeBundle::Type,
                    'target_bundles' => [
                        'slide' =>  'slide',
                    ],
                    'cardinality' => BaseStorage::MultipleCardinality,
                ],
            ],
        ],
        'invite' => [
            'label' => 'field.invite.label',
            'fields' => [
                'field_title' => [
                    'class' => StringField::class,
                    'label' => 'field.title.label',
                ],
                'field_description' => [
                    'class' => StringLongField::class,
                    'label' => 'field.description.label',
                ],
                'field_date' => [
                    'class' => TimestampField::class,
                    'label' => 'field.start_date.label',
                    'required' => true,
                ],
                'field_end_date' => [
                    'class' => TimestampField::class,
                    'label' => 'field.end_date.label',
                    'required' => true,
                ],
                'field_place' => [
                    'class' => StringField::class,
                    'label' => 'field.place.label',
                ],
                'field_invite_link' => [
                    'class' => StringField::class,
                    'label' => 'field.link.label',
                ],
            ],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Global Fields
    |--------------------------------------------------------------------------
    |
    | These fields are present in every paragraph, we overloads to add
    | the appropriate translations.
    |
    */
    'default.fields' => [
        'status' => [
            'label' => 'field.published.label',
            'type' => BooleanStorage::Type,
            'settings' => [
                'on_label' => 'field.enable.label',
                'off_label' => 'field.disable.label',
            ],
            'default_value' => [
                ['value' => 1],
            ],
        ],
        'created' => [
            'label' => 'field.written_on.label',
            'type' => 'created',
            'description' => 'field.written_on.description',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Global Paragraphs
    |--------------------------------------------------------------------------
    |
    | These paragraphs must be present on all intranet-inside v2.
    | When generating the paragraphs, they will be automatically used to
    | create the appropriate Drupal configuration for the intranet.
    |
    */
    'default.paragraphs' => [
        'accordion' => [
            'label' => 'field.accordion.label',
            'fields' => [
                'field_question' => [
                    'class' => StringField::class,
                    'label' => 'field.question.label',
                ],
                'field_answer' => [
                    'class' => TextLongField::class,
                    'label' => 'field.answer.label',
                ],
            ],
        ],

        'button' => [
            'label' => 'field.button.label',
            'fields' => [
                'field_button_alignment' => [
                    'class' => StringListField::class,
                    'label' => 'field.button_alignment.label',
                    'required' => true,
                    'storage.settings' => [
                        'allowed_values' => [
                            ['value' => 'left', 'label' => 'field.left.label'],
                            ['value' => 'center', 'label' => 'field.center.label'],
                            ['value' => 'right', 'label' => 'field.right.label'],
                        ],
                    ],
                ],
                'field_button_color' => [
                    'class' => StringField::class,
                    'label' => 'field.button_color.label',
                    'required' => true,
                    'default_value' => '#ffffff',
                ],
                'field_button_text' => [
                    'class' => StringField::class,
                    'label' => 'field.button_text.label',
                    'required' => true,
                ],
                'field_button_uri' => [
                    'class' => StringField::class,
                    'label' => 'field.button_uri.label',
                    'required' => true,
                ],
            ],
        ],

        'call_to_action' => [
            'label' => 'field.call_to_action.label',
            'fields' => [
                'field_cta_link' => [
                    'class' => StringField::class,
                    'label' => 'field.link.label',
                ],
                'field_open_in_new_tab' => [
                    'class' => BooleanField::class,
                    'label' => 'field.open_in_new_tab.label',
                ],
                'field_body' => [
                    'class' => TextLongField::class,
                    'label' => 'field.body.label',
                ],
                'field_title' => [
                    'class' => StringField::class,
                    'label' => 'field.title.label',
                    'third_party_settings' => [
                        'inside' => [
                            'search' => [
                                'searchable' => true,
                                'field_boost' => 1,
                            ],
                        ],
                    ],
                ],
                'field_link_title' => [
                    'class' => StringField::class,
                    'label' => 'field.link_title.label',
                ],
            ],
        ],

        'file' => [
            'label' => 'field.file.label',
            'fields' => [
                'field_file' => [
                    'class' => FileField::class,
                    'label' => 'field.file.label',
                    'required' => true,
                ],
                'field_title' => [
                    'class' => StringField::class,
                    'label' => 'field.title.label',
                    'third_party_settings' => [
                        'inside' => [
                            'search' => [
                                'searchable' => true,
                                'field_boost' => 1,
                            ],
                        ],
                    ],
                ],
                'field_description' => [
                    'class' => StringLongField::class,
                    'label' => 'field.description.label',
                ],
            ],
        ],

        'files' => [
            'label' => 'field.files.label',
            'fields' => [
                'field_content' => [
                    'class' => EntityReferenceRevisionsField::class,
                    'label' => 'field.content.label',
                    'target_type' => ParagraphsTypeBundle::Type,
                    'target_bundles' => [
                        'file' => 'file',
                    ],
                    'cardinality' => BaseStorage::MultipleCardinality,
                ],
            ],
        ],

        'html' => [
            'label' => 'field.html.label',
            'fields' => [
                'field_html' => [
                    'class' => StringLongField::class,
                    'label' => 'field.html.label',
                ],
            ],
        ],

        'image' => [
            'label' => 'field.image.label',
            'fields' => [
                'field_image_link' => [
                    'class' => StringField::class,
                    'label' => 'field.image_link.label',
                    'description' => 'field.image_link.description',
                ],
                'field_image' => [
                    'class' => ImageField::class,
                    'label' => 'field.image.label',
                    'required' => true,
                ],
            ],
        ],

        'map' => [
            'label' => 'field.map.label',
            'fields' => [
                'field_address' => [
                    'class' => StringLongField::class,
                    'label' => 'field.address.label',
                ],
                'field_latitude' => [
                    'class' => StringField::class,
                    'label' => 'field.latitude.label',
                ],
                'field_place' => [
                    'class' => StringField::class,
                    'label' => 'field.place.label',
                ],
                'field_longitude' => [
                    'class' => StringField::class,
                    'label' => 'field.longitude.label',
                ],
            ],
        ],

        'separator' => [
            'label' => 'field.separator.label',
        ],

        'text' => [
            'label' => 'field.text.label',
            'fields' => [
                'field_body' => [
                    'class' => TextLongField::class,
                    'label' => 'field.body.label',
                ],
            ],
        ],

        'text_two_columns' => [
            'label' => 'field.text_two_columns.label',
            'fields' => [
                'field_text_left' => [
                    'class' => TextWithSummaryField::class,
                    'label' => 'field.text_left.label',
                ],
                'field_text_right' => [
                    'class' => TextWithSummaryField::class,
                    'label' => 'field.text_right.label',
                ],
            ],
        ],

        'text_with_image' => [
            'label' => 'field.text_with_image.label',
            'fields' => [
                'field_body' => [
                    'class' => TextLongField::class,
                    'label' => 'field.body.label',
                ],
                'field_display' => [
                    'class' => StringListField::class,
                    'label' => 'field.display.label',
                    'storage.settings' => [
                        'allowed_values' => [
                            ['value' => 'left', 'label' => 'field.left.label'],
                            ['value' => 'center', 'label' => 'field.center.label'],
                            ['value' => 'right', 'label' => 'field.right.label'],
                        ],
                    ],
                ],
                'field_image' => [
                    'class' => ImageField::class,
                    'label' => 'field.image.label',
                    'required' => true,
                ],
            ],
        ],

        'tweet' => [
            'label' => 'field.tweet.label',
            'fields' => [
                'field_tweet_id' => [
                    'class' => StringField::class,
                    'label' => 'field.tweet_id.label',
                    'description' => 'field.tweet_id.description',
                ],
            ],
        ],

        'video' => [
            'label' => 'field.video.label',
            'fields' => [
                'field_file' => [
                    'class' => VideoField::class,
                    'label' => 'field.file.label',
                ],
            ],
        ],
    ],
];
