<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'stock_prices',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'en' => 'Stock Prices',
            'fr' => 'Cours de Bourse',
            'es' => 'Cotización Bursátil',
            'pt' => 'Cotação da Bolsa',
            'nl' => 'Aandelenkoersen',
            'de' => 'Börsenkurse',
        ],
    ],
    'fields' => [
        [
            'name' => 'stock_id',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'en' => 'Identifier',
                'fr' => 'Identifiant',
                'es' => 'Identificador',
                'pt' => 'Identificação',
                'nl' => 'Identificatie',
                'de' => 'Kennung',
            ],
            'description' => [
                'fr' => "Pour retrouver la l'identifiant du cours de votre action rendez-vous sur le site https://wise.com/fr/stock/ et récupérez le code de l'action",
                'en' => 'To find the identifier of the price for your stock, go to the website https://wise.com/fr/stock/ and retrieve the stock code.',
                'de' => 'Um die Kennung des Kurses für Ihre Aktie zu finden, besuchen Sie die Website https://wise.com/fr/stock/ und notieren Sie den Aktiencode.',
                'es' => 'Para encontrar el identificador del precio de su acción, visite el sitio web https://wise.com/fr/stock/ y recupere el código de la acción.',
                'pt' => 'Para encontrar o identificador do preço da sua ação, acesse o site https://wise.com/fr/stock/ e recupere o código da ação.',
                'nl' => 'Om de identificatie van de prijs voor uw aandeel te vinden, gaat u naar de website https://wise.com/fr/stock/ en haalt u de aandelencode op.',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Image',
                'en' => 'Image',
                'es' => 'Imagen',
                'de' => 'Bild',
                'pt' => 'Imagem',
                'nl' => 'Afbeelding',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'en' => 'Weight',
                'fr' => 'Poids',
                'es' => 'Peso',
                'pt' => 'Peso',
                'nl' => 'Gewicht',
                'de' => 'Gewicht',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'currency',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'en' => 'Currency',
                'fr' => 'Devise',
                'es' => 'Moneda',
                'pt' => 'Moeda',
                'nl' => 'Valuta',
                'de' => 'Währung',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'price',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'en' => 'Current Price',
                'fr' => 'Prix courant',
                'es' => 'Precio actual',
                'pt' => 'Preço atual',
                'nl' => 'Huidige prijs',
                'de' => 'Aktueller Preis',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 1,
                'hidden' => true,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'change_percent',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'en' => 'Percentage Differential',
                'fr' => 'Pourcentage différenciel',
                'es' => 'Porcentaje diferencial',
                'pt' => 'Porcentagem diferencial',
                'nl' => 'Veranderingspercentage',
                'de' => 'Differenzielle Prozentual',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 4,
                'hidden' => true,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
