<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'postings_categories',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Catégorie de petite annonce',
            'en' => 'Ads category',
            'de' => 'Kategorie der Kleinanzeige',
            'nl' => 'Categorie van kleine advertenties',
            'es' => 'Categoría de anuncio clasificado',
            'pt' => 'Categoria de anúncio classificado',
        ],
    ],
    'fields' => [
        [
            'name' => 'color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Couleur',
                'en' => 'Color',
                'de' => 'Farbe',
                'nl' => 'Kleur',
                'es' => 'Color',
                'pt' => 'Cor',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Image',
                'en' => 'Picture',
                'de' => 'Bild',
                'nl' => 'Afbeelding',
                'es' => 'Imagen',
                'pt' => 'Imagem',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
