<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'flash_news',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Flash info',
            'en' => 'Flash info',
            'es' => 'Flash info',
            'de' => 'Flash info',
            'pt' => 'Newsflash',
            'nl' => 'Nieuwsflitsing',
        ],
    ],
    'fields' => [
        [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Icone',
                'en' => 'Icon',
                'es' => 'Icono',
                'de' => 'Symbol',
                'pt' => 'Icone',
                'nl' => 'Icoon',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'background_color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Couleur de fond',
                'en' => 'Background color',
                'es' => 'Color de fondo',
                'de' => 'Hintergrundfarbe',
                'pt' => 'Cor de fundo',
                'nl' => 'Achtergrondkleur',
            ],
            'description' => [
                'fr' => 'Si aucune couleur n\'est sélectionnée, la couleur secondaire du site sera utilisée.',
                'en' => 'If no color is selected, the secondary color of the website will be used.',
                'es' => 'Si no se selecciona ningún color, se utilizará el color secundario del sitio web.',
                'de' => 'Wenn keine Farbe ausgewählt ist, wird die sekundäre Farbe der Website verwendet.',
                'pt' => 'Se nenhuma cor for selecionada, será utilizada a cor secundária do site.',
                'nl' => 'Als er geen kleur is geselecteerd, wordt de secundaire kleur van de website gebruikt.',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'dark_mode',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Mode sombre',
                'en' => 'Dark mode',
                'es' => 'Modo oscuro',
                'de' => 'Dunkler Modus',
                'pt' => 'Modo escuro',
                'nl' => 'Donkere modus',
            ],
            'description' => [
                'fr' => 'Si le dark mode est activé, le texte et l\'icone seront blancs',
                'en' => 'If the dark mode is activated, the text and the icon will be white.',
                'es' => 'Si el modo oscuro está activado, el texto y el icono serán de color blanco.',
                'de' => 'Wenn der Dunkelmodus aktiviert ist, sind der Text und das Symbol weiß.',
                'pt' => 'Se o modo escuro estiver activado, o texto e o ícone ficarão brancos.',
                'nl' => 'Als de donkere modus wordt geactiveerd, zijn de tekst en het pictogram wit.',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'flash_content',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
                'es' => 'Contenido',
                'de' => 'Inhalt',
                'pt' => 'Conteúdo',
                'nl' => 'Inhoud',
            ],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'end_date',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Date de fin',
                'en' => 'End date',
                'es' => 'Fecha final',
                'de' => 'Endtermin',
                'pt' => 'Data final',
                'nl' => 'Einddatum',
            ],
            'description' => [
                'fr' => 'Choix de la date et heure de dépublication du flash info',
                'en' => 'Choice of the date and time of depublication of the flash info',
                'es' => 'Elección de la fecha y hora de publicación de la información flash',
                'de' => 'Wahl des Datums und der Uhrzeit der Veröffentlichung der Flash-Info',
                'pt' => 'Escolha da data e hora da publicação da notícia flash',
                'nl' => 'Keuze van datum en tijd van het depublicatie van de infl fash',
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
    ],
];
