<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'faq_questions',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Question FAQ',
            'en' => 'Question FAQ',
            'es' => 'Question FAQ',
            'de' => 'Question FAQ',
            'pt' => 'Pergunta de perguntas frequentes',
            'nl' => 'Vraag FAQ',
        ],
    ],
    'fields' => [
        [
            'name' => 'faq_categories',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Catégorie FAQ',
                'en' => 'Category FAQs',
                'es' => 'Preguntas frecuentes sobre la categoría',
                'de' => 'Häufig gestellte Fragen zu Kategorien',
                'pt' => 'Categoria de perguntas frequentes',
                'nl' => 'Categorie Veelgestelde vragen',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['faq_categories'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'weight',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'order of appearance',
                'es' => 'orden de aparición',
                'de' => 'Reihenfolge des Erscheinens',
                'pt' => 'ordem de aparência',
                'nl' => 'verschijning volgorde',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number goes up in 1st',
                'es' => 'El número más bajo sube en 1er.',
                'de' => 'Die niedrigste Zahl steigt in 1.',
                'pt' => 'O valor mais baixo foi em 1',
                'nl' => 'Het laagste getal komt in 1e',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Réponse',
                'en' => 'Answer',
                'es' => 'Responder',
                'de' => 'Antworten',
                'pt' => 'Responder',
                'nl' => 'Antwoorden',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'tweet',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
    ],
];
