<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'alphabet_books',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Abécédaire',
            'en' => 'Alphabet book',
            'de' => 'Alphabetbuch',
            'nl' => 'Alfabetboek',
            'es' => 'Libro de alfabeto',
            'pt' => 'Livro de alfabeto',
        ],
    ],
    'fields' => [
        [
            'name' => 'alphabet_books_categories',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Catégorie abécédaire',
                'en' => 'Alphabet book category',
                'de' => 'Alphabetbuchkategorie',
                'nl' => 'Alfabetboek categorie',
                'es' => 'Categoría de libro de alfabeto',
                'pt' => 'Categoria de livro de alfabeto',
            ],
            'widget' => [
                'hidden' => true,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['alphabet_books_categories'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
                'de' => 'Inhalt',
                'nl' => 'Inhoud',
                'es' => 'Contenido',
                'pt' => 'Conteúdo',
            ],
            'description' => [
                'fr' => 'Sélectionnez les différents types de paragraphes que vous voulez faire remonter sur la page',
                'en' => 'Select the different types of paragraphs you want to move up the page',
                'de' => 'Wählen Sie die verschiedenen Arten von Absätzen aus, die Sie auf der Seite nach oben verschieben möchten',
                'nl' => 'Selecteer de verschillende soorten alinea\'s die u naar boven wilt verplaatsen op de pagina',
                'es' => 'Seleccione los diferentes tipos de párrafos que desea subir en la página',
                'pt' => 'Selecione os diferentes tipos de parágrafos que você deseja mover para cima na página',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'tweet',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
    ],
];
