<?php

declare(strict_types=1);

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'wttj_applications',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Application WTTJ',
            'en' => 'WTTJ Application',
            'es' => 'Aplicación WTTJ',
            'de' => 'WTTJ-App',
            'pt' => 'Aplicativo WTTJ',
        ],
    ],
    'fields' => [
        [
            'name' => 'wttj_reference',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'title' => [
                'fr' => 'Référence WTTJ',
                'en' => 'WTTJ Reference',
                'es' => 'Referencia WTTJ',
                'de' => 'Referenz WTTJ',
                'pt' => 'Referência WTTJ',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
