<?php

declare(strict_types=1);

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'job_offers',
    ],
    'fields' => [
        [
            'name' => 'external_reference',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'title' => [
                'en' => 'External Reference',
                'es' => 'Referencia Externa',
                'de' => 'Externe Referenz',
                'nl' => 'Externe Referentie',
                'pt' => 'Referência Externa',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'external_link',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'title' => [
                'fr' => 'Lien Externe',
                'en' => 'External Link',
                'es' => 'Enlace Externo',
                'de' => 'Externer Link',
                'nl' => 'Externe Link',
                'pt' => 'Link Externo',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'forms',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'title' => [
                'fr' => 'Formulaire associé',
                'en' => 'Formulaire associé',
                'es' => 'Formulario asociado',
                'de' => 'Zugehöriges Formular',
                'nl' => 'Bijbehorend formulier',
                'pt' => 'Formulário associado',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['forms'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'wttj_applications',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'title' => [
                'fr' => 'Application WTTJ',
                'en' => 'WTTJ App',
                'es' => 'Aplicación WTTJ',
                'de' => 'WTTJ-Anwendung',
                'nl' => 'WTTJ-toepassing',
                'pt' => 'Aplicativo WTTJ',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['wttj_applications'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'locations',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'title' => [
                'fr' => 'Localisation',
                'en' => 'Localization',
                'es' => 'Localización',
                'de' => 'Lokalisierung',
                'nl' => 'Lokalisatie',
                'pt' => 'Localização',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['locations'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'contracts',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'title' => [
                'fr' => 'Type de contrat',
                'en' => 'Contract type',
                'es' => 'Tipo de contrato',
                'de' => 'Vertragstyp',
                'nl' => 'Contracttype',
                'pt' => 'Tipo de contrato',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['contracts'],
                'cardinality' => 1,
            ],
        ],
    ],
];
