<?php

use Illuminate\Database\Connection;
use Illuminate\Database\Connectors\MySqlConnector;
use Inside\Database\PostgresConnection;
use Illuminate\Support\Facades\Log;
use Inside\Database\MysqlConnection;
use NunoMaduro\Collision\Adapters\Laravel\CollisionServiceProvider;
use NunoMaduro\Collision\Provider;
use Symfony\Component\HttpFoundation\Request;

if (!isset($autoload)) {
    $autoload = __DIR__ . '/../vendor/autoload.php';
}

if (!file_exists(realpath($autoload))) {
    $autoload = __DIR__ . '/../../../autoload.php';
}

if (!file_exists(realpath($autoload))) {
    $autoload = __DIR__ . '/../../../../vendor/autoload.php';
}
require_once $autoload;

date_default_timezone_set('UTC');

/*
|--------------------------------------------------------------------------
| Create The Application
|--------------------------------------------------------------------------
*/
// Reset Symfony Request from Drupal 9
Request::setFactory(null);

(new Laravel\Lumen\Bootstrap\LoadEnvironmentVariables(
    realpath(dirname(__DIR__, 4))
))->bootstrap();


$app = new \Inside\Application(
    realpath(__DIR__ . '/../')
);

$app->withFacades(
    true,
    [
        'Illuminate\Support\Facades\File' => 'File',
        'Illuminate\Support\Facades\Storage' => 'Storage',
        'Intervention\Image\Facades\Image' => 'Image',
    ]
);

Connection::resolverFor(
    'imysql',
    function ($connection, $database, $prefix, $config) {
        return new MysqlConnection($connection, $database, $prefix, $config);
    }
);

Connection::resolverFor(
    'pgsql',
    function ($connection, $database, $prefix, $config) {
        return new PostgresConnection($connection, $database, $prefix, $config);
    }
);

$app->bind('db.connector.imysql', MySqlConnector::class);

$app->withEloquent();

if (env('APP_DEBUG')) {
    \DB::enableQueryLog();
}
// We need to start from cms base path, Drupal use Cwd to discover stuff
chdir(cms_base_path());

/*
|--------------------------------------------------------------------------
| Register Container Bindings
|--------------------------------------------------------------------------
*/

$app->singleton(
    Illuminate\Contracts\Debug\ExceptionHandler::class,
    Inside\Exceptions\Handler::class
);

$app->singleton(
    Illuminate\Contracts\Console\Kernel::class,
    Inside\Console\Kernel::class
);

$app->singleton(
    'cookie',
    function () use ($app) {
        return $app->loadComponent('session', 'Illuminate\Cookie\CookieServiceProvider', 'cookie');
    }
);

$app->bind('Illuminate\Contracts\Cookie\QueueingFactory', 'cookie');

$app->configure('app');
$app->configure('view');

$app->singleton(Illuminate\Session\SessionManager::class, function () use ($app) {
    return $app->loadComponent('session', Illuminate\Session\SessionServiceProvider::class, 'session');
});

$app->singleton('session.store', function () use ($app) {
    return $app->loadComponent('session', Illuminate\Session\SessionServiceProvider::class, 'session.store');
});

/*
|--------------------------------------------------------------------------
| Register Middleware
|--------------------------------------------------------------------------
*/
$app->middleware(
    [
        Inside\Http\Middleware\ServerPerformanceMonitor::class,
        Inside\Http\Middleware\Headers\AccessControlMiddleware::class,
        Inside\Http\Middleware\Headers\ContentSecurityPolicyMiddleware::class,
        Inside\Http\Middleware\Headers\FeaturePolicyMiddleware::class,
        Inside\Http\Middleware\Headers\ExpectCTMiddleware::class,
        Inside\Http\Middleware\Headers\ServiceWorkerMiddleware::class,
        Inside\Http\Middleware\Headers\SecurityMiddleware::class,
        Inside\Http\Middleware\LocaleMiddleware::class,
        Inside\Http\Middleware\CheckForMaintenanceMode::class,
        Inside\Http\Middleware\EncryptCookies::class,
        Inside\Http\Middleware\ValidatePostSize::class,
        Inside\Http\Middleware\TrimStrings::class,
        Illuminate\Session\Middleware\StartSession::class,
        Inside\Http\Middleware\ConvertEmptyStringsToNull::class,
        Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
        Illuminate\Session\Middleware\StartSession::class,
    ]
);
$app->routeMiddleware([
    'front-check' => Inside\Http\Middleware\CheckForFrontendRebuild::class,
]);

/*
|--------------------------------------------------------------------------
| Register Service Providers
|--------------------------------------------------------------------------
*/
try {
    $app->register(Illuminate\Redis\RedisServiceProvider::class);
    $app->register(Laravel\Tinker\TinkerServiceProvider::class);
    $app->register(Intervention\Image\ImageServiceProvider::class);
    $app->register(Inside\Providers\AppServiceProvider::class);
    $app->register(Inside\Providers\RouteServiceProvider::class);
    $app->register(Inside\Providers\BroadcastServiceProvider::class);
    $app->register(Inside\Horizon\HorizonServiceProvider::class);

    if ($app->environment() !== 'production' && class_exists(Provider::class)) {
        $app->register(CollisionServiceProvider::class);
    }
} catch (Exception $e) {
    Log::emergency($e->getMessage());
}

return $app;
