<?php

declare(strict_types=1);

use Illuminate\Support\Facades\Route;
use Inside\Authentication\Http\Controllers\Auth\AvailableCookie;
use Inside\Authentication\Http\Controllers\Auth\Check;
use Inside\Authentication\Http\Controllers\Auth\ExternalLogin;
use Inside\Authentication\Http\Controllers\Auth\Kick;
use Inside\Authentication\Http\Controllers\Auth\KickAll;
use Inside\Authentication\Http\Controllers\Auth\Login;
use Inside\Authentication\Http\Controllers\Auth\LoginAs;
use Inside\Authentication\Http\Controllers\Auth\Logout;
use Inside\Authentication\Http\Controllers\Auth\Show;
use Inside\Authentication\Http\Controllers\Otp\Check as OtpCheck;

Route::group(
    [
        'prefix' => 'api/v1',
    ],
    function ($router) {
        $router->post('authentication/login', ['uses' => Login::class, 'middleware' => 'captcha']);
        $router->post('authentication/loginAs', ['uses' => LoginAs::class, 'middleware' => 'auth.maecia']);
        $router->post('authentication/external-login', ['uses' => ExternalLogin::class]);
        $router->post('authentication/kick', ['uses' => Kick::class, 'middleware' => 'auth.maecia']);
        $router->post('authentication/kickAll', ['uses' => KickAll::class, 'middleware' => 'auth.maecia']);
        $router->post('authentication/logout', ['uses' => Logout::class, 'middleware' => 'auth.api']);
        $router->get('authentication/current', ['uses' => Show::class, 'middleware' => 'auth.api']);
        $router->get('authentication/check', Check::class);
        $router->get('authentication/available-cookie', AvailableCookie::class);
        $router->post('authentication/otp/check', OtpCheck::class);
    }
);

Route::group(
    [
        'namespace' => 'Inside\Authentication\Http\Controllers',
        'prefix' => 'api/v1',
    ],
    function ($router) {
        $router->post(
            'external/authentication/login',
            [
                'uses' => 'ExternalAuthenticationController@login',
            ]
        );

        $router->post(
            'external/authentication/logout',
            [
                'uses' => 'ExternalAuthenticationController@logout',
                'middleware' => 'auth.external',
            ]
        );

        $router->post(
            'external/authentication/refresh',
            [
                'uses' => 'ExternalAuthenticationController@refresh',
                'middleware' => 'auth.external',
            ]
        );

        $router->post(
            'external/authentication/check',
            [
                'uses' => 'ExternalAuthenticationController@check',
                'middleware' => 'auth.external',
            ]
        );
        $router->get(
            'token/index',
            [
                'uses' => 'TokenController@index',
                'middleware' => 'auth.maecia',
            ]
        );
    }
);
