<?php

namespace Inside\Authentication\Services;

use Carbon\CarbonInterval;
use Inside\Authentication\Contracts\InsideSessionLifetime;
use Inside\Settings\Facades\Settings;

class InsideSessionLifetimeService implements InsideSessionLifetime
{
    public function getAuthenticatorLifetime(string $authenticator, bool $longer): ?int
    {
        return match ($authenticator) {
            'cli' => null,
            'inside', 'ldap' => $longer
                ? $this->getSessionLifetime()
                : $this->getSessionLongerLifetime(),
            default => $this->getSessionSSOLifetime()
        };
    }

    public function getSessionLifetime(): int
    {
        $lifetime = Settings::get('loginpage', 'inside_session_lifetime', config('session.lifetime'));

        return (int) $lifetime;
    }

    public function getSessionLongerLifetime(): int
    {
        $lifetime = Settings::get('loginpage', 'inside_session_longer_lifetime', config('session.longer_lifetime'));

        return (int) $lifetime;
    }

    public function getSessionSSOLifetime(): int
    {
        $lifetime = Settings::get('loginpage', 'inside_session_sso_lifetime', config('session.sso_lifetime'));

        return (int) $lifetime;
    }
}
