<?php

namespace Inside\Authentication\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property int $id
 * @property string $authenticator
 * @property string $user_uuid
 * @property string $token
 * @property \Illuminate\Support\Carbon|null $last_used_at
 * @property array|null $abilities
 * @property array|null $device
 * @property string|null $last_login_ip
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property bool $longer_lifetime
 * @property-read mixed $created_at_timestamp
 * @property-read mixed $has_expired
 * @property-read mixed $last_used_at_timestamp
 * @property-read User $user
 * @method static Builder|Token active()
 * @method static Builder|Token newModelQuery()
 * @method static Builder|Token newQuery()
 * @method static Builder|Token query()
 * @method static Builder|Token whereAbilities($value)
 * @method static Builder|Token whereAuthenticator($value)
 * @method static Builder|Token whereCreatedAt($value)
 * @method static Builder|Token whereDevice($value)
 * @method static Builder|Token whereId($value)
 * @method static Builder|Token whereLastLoginIp($value)
 * @method static Builder|Token whereLastUsedAt($value)
 * @method static Builder|Token whereLongerLifetime($value)
 * @method static Builder|Token whereToken($value)
 * @method static Builder|Token whereUpdatedAt($value)
 * @method static Builder|Token whereUserUuid($value)
 * @mixin \Eloquent
 * @mixin Builder
 */
class OtpToken extends Model
{
    protected $table = 'inside_otp_tokens';

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_uuid', 'uuid');
    }
}
