<?php

namespace Inside\Authentication\Models;

use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Inside\Database\Eloquent\WithEnhancedBuilder;
use Tymon\JWTAuth\Contracts\JWTSubject;

/**
 * Inside\Authentication\Models\ApplicationClient
 *
 * @property int $id
 * @property string $name
 * @property string|null $secret
 * @property string|null $type
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Inside\Database\Eloquent\Builder|ApplicationClient newModelQuery()
 * @method static \Inside\Database\Eloquent\Builder|ApplicationClient newQuery()
 * @method static \Inside\Database\Eloquent\Builder|ApplicationClient query()
 * @method static Builder|ApplicationClient whereCreatedAt($value)
 * @method static Builder|ApplicationClient whereId($value)
 * @method static Builder|ApplicationClient whereName($value)
 * @method static Builder|ApplicationClient whereSecret($value)
 * @method static Builder|ApplicationClient whereType($value)
 * @method static Builder|ApplicationClient whereUpdatedAt($value)
 * @mixin \Eloquent
 * @mixin Builder
 */
class ApplicationClient extends Model implements JWTSubject, AuthenticatableContract
{
    use WithEnhancedBuilder;

    protected $table = 'inside_application_clients';

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims(): array
    {
        return [
            'type' => $this->type,
        ];
    }

    public function getAuthIdentifierName(): string
    {
        return 'id';
    }

    public function getAuthIdentifier()
    {
        return $this->getKey();
    }

    public function getAuthPassword(): ?string
    {
        return $this->secret;
    }

    public function getRememberToken()
    {
    }

    public function setRememberToken($value)
    {
    }

    public function getRememberTokenName()
    {
    }
}
