<?php

namespace Inside\Authentication\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Authentication\Models\Token;
use Inside\User\Events\UserDisabledEvent;

/**
 * User login listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class UserDisabledListener implements ShouldQueue
{
    public function handle(UserDisabledEvent $event): void
    {
        Token::where('user_uuid', $event->userUuid)->delete();
    }
}
