<?php

namespace Inside\Authentication\Listeners;

use Illuminate\Events\Dispatcher;
use Illuminate\Support\Facades\App;
use Inside\Authentication\Events\AuthenticationLoginEvent;

/**
 * AuthenticationEventSubscriber
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @link     http://www.maecia.com/
 */
class AuthenticationEventSubscriber
{
    /**
     * hand User login
     *
     * @param AuthenticationLoginEvent $event
     * @return void
     */
    public function handleUserLogin(AuthenticationLoginEvent $event): void
    {
        // Switch app locale to $user langcode
        App::setLocale($event->user->langcode ?? config('app.locale'));
    }

    /**
     * Register the listeners for the subscriber.
     */
    public function subscribe(Dispatcher $events): array
    {
        return [
            AuthenticationLoginEvent::class => 'handleUserLogin',
        ];
    }
}
