<?php

namespace Inside\Authentication\Jobs;

use Inside\Authentication\Facades\InsideSessionLifetime;
use Inside\Authentication\Models\Token;
use Inside\Jobs\Job;

/**
 * Class Cleanup
 */
class TokensCleanup extends Job
{
    public function handle(): void
    {
        $expirationDate = now()->subMinutes(InsideSessionLifetime::getSessionLifetime());

        Token::where(function ($query) use ($expirationDate) {
            $query->where(function ($query) use ($expirationDate) {
                $query->whereNull('last_used_at')->where('created_at', '<', $expirationDate);
            })->orWhere('last_used_at', '<', $expirationDate);
        })->delete();
    }
}
