<?php

namespace Inside\Authentication\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Inside\Authentication\Models\User;
use Inside\Permission\Exceptions\AuthorizationException;

class MaeciaAdminMiddleware
{
    public function handle(Request $request, Closure $next): mixed
    {
        $me = Auth::user();
        if (! $me instanceof User) {
            throw new AuthorizationException('This action is unauthorized.');
        }
        $user = User::find($me->uuid);
        if (! $user || ! $user->hasRole('super_administrator') || ! Str::endsWith($user->email, '@maecia.com')) {
            throw new AuthorizationException('This action is unauthorized.');
        }

        return $next($request);
    }
}
