<?php

namespace Inside\Authentication\Http\Middleware;

use Closure;
use GuzzleHttp\Client;
use Illuminate\Auth\AuthenticationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Log;

/**
 * Inside Captcha middleware.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class CaptchaMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @throws AuthenticationException
     */
    public function handle(Request $request, Closure $next): mixed
    {
        if (env('ENABLE_CAPTCHA', false) && ! $this->isValid($request)) {
            Log::debug('Invalid captcha token', ['uri' => $request->getUri()]);

            throw new AuthenticationException(Lang::get('captcha.token.invalid'));
        }

        return $next($request);
    }

    /**
     * Check if a given TOKEN is valid
     *
     * @return bool
     */
    private function isValid(Request $request): bool
    {
        if (! $request->json()->get('captcha_token')) {
            return false;
        }
        $token = $request->json()->get('captcha_token');

        $client = new Client();

        $response = $client->post(
            'https://www.google.com/recaptcha/api/siteverify',
            [
                'form_params' => [
                    'secret'   => env('GOOGLE_RECAPTCHA_SECRET'),
                    'response' => $token,
                ],
            ]
        );

        $body = json_decode((string) $response->getBody());

        return $body->success;
    }
}
