<?php

namespace Inside\Authentication\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Authentication\Facades\InsideSessionLifetime;
use Inside\Authentication\Models\Token;

/**
 * Inside Token controller.
 *
 * @OA\Tag(name="Token",description="Ce controller permet de gérer les tokens d'identification")
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class TokenController
{
    /**
     * List current used token
     */
    public function index(Request $request): JsonResponse
    {
        $filters = [];
        if ($request->has('filters')) {
            $filters = json_decode($request->get('filters'), true) ?? [];
        }
        $perPage = $filters['limit'] ?? 10;

        $tokens = Token::with('user.information')->when(
            $request->has('query'),
            function ($query) use ($request) {
                $search = $request->get('query');
                $query->whereHas(
                    'user.information',
                    function ($query) use ($search) {
                        $query->where('lastname', 'like', '%'.$search.'%')->orWhere(
                            'firstname',
                            'like',
                            '%'.$search.'%'
                        )->orWhere('email', 'like', '%'.$search.'%');
                    }
                );
            }
        )->when(
            isset($filters['authenticator']),
            function ($query) use ($filters) {
                $query->where('authenticator', $filters['authenticator']);
            }
        )->when(
            isset($filters['has_expired']),
            function ($query) use ($filters) {
                if ($filters['has_expired']) {
                    $query->where(
                        'last_used_at',
                        '<',
                        now()->subMinutes(InsideSessionLifetime::getSessionLifetime())
                    );
                } else {
                    $query->where(
                        'last_used_at',
                        '>=',
                        now()->subMinutes(InsideSessionLifetime::getSessionLifetime())
                    );
                }
            }
        )->orderByDesc('last_used_at')->paginate($perPage);

        return response()->json($tokens);
    }
}
