<?php

declare(strict_types=1);

namespace Inside\Authentication\Http\Controllers\Auth;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Authentication\Contracts\Authentication as AuthenticationContract;
use Inside\Authentication\Facades\Authentication;
use Inside\Authentication\Http\Controllers\Controller;

final class KickAll extends Controller
{
    public function __invoke(Request $request, AuthenticationContract $authentication): JsonResponse
    {
        $authentication->kickAll($request->get('reason'));

        return response()->json([
            'success' => true,
        ]);
    }
}
