<?php

declare(strict_types=1);

namespace Inside\Authentication\Http\Controllers\Auth;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Authentication\Contracts\Authentication as AuthenticationContract;
use Inside\Authentication\Http\Controllers\Controller;
use Inside\Authentication\Models\User;
use InvalidArgumentException;

final class Kick extends Controller
{
    /**
     * @throws InvalidArgumentException
     */
    public function __invoke(Request $request, AuthenticationContract $authentication): JsonResponse
    {
        $requestUuid = $request->get('uuid');
        if ($requestUuid === null) {
            throw new InvalidArgumentException('invalid argument');
        }

        $reason = $request->get('reason');

        // Load user
        $user = User::findOrFail($requestUuid);

        $authentication->kickUser($user, $reason);

        return response()->json([
            'success' => true,
        ]);
    }
}
