<?php

declare(strict_types=1);

namespace Inside\Authentication\Http\Controllers\Auth;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Authentication\Facades\Authentication;
use Inside\Authentication\Http\Controllers\Controller;

final class AvailableCookie extends Controller
{
    public function __invoke(Request $request): JsonResponse
    {
        return response()->json(['data' => (bool) Authentication::getUserFromMagicCookie($request)]);
    }
}
