<?php

namespace Inside\Authentication\Events;

use Inside\Authentication\Models\User;
use Inside\Events\Dispatchable;

/**
 * Class UserUndescisionized
 */
class UserUndecisionized
{
    use Dispatchable;

    public function __construct(
        public User $user
    ) {
    }

    public function getUserUuid(): string
    {
        return $this->user->uuid;
    }

    public function getUser(): User
    {
        return $this->user;
    }
}
