<?php

namespace Inside\Authentication\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Queue\SerializesModels;
use Inside\Authentication\Models\User;
use Inside\Events\Dispatchable;

class UserDeletedEvent implements ShouldBroadcastNow
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    public function __construct(
        public User $user
    ) {
    }

    /**
     * Get the channels the event should broadcast on.
     */
    public function broadcastOn(): PrivateChannel
    {
        return new PrivateChannel('inside.users');
    }

    /**
     * @return string
     */
    public function broadcastAs(): string
    {
        return 'inside.users.deleted';
    }
}
