<?php

namespace Inside\Authentication\Events;

use Inside\Authentication\Models\User;
use Inside\Events\Dispatchable;

/**
 * Class UserDescisionized
 */
class UserDecisionized
{
    use Dispatchable;

    public function __construct(
        public User $user
    ) {
    }

    public function getUserUuid(): string
    {
        return $this->user->uuid;
    }

    public function getUser(): User
    {
        return $this->user;
    }
}
