<?php

namespace Inside\Authentication\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Queue\SerializesModels;
use Inside\Authentication\Models\User;
use Inside\Events\Dispatchable;

/**
 * Authentication logout event.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class AuthenticationLogoutEvent implements ShouldBroadcastNow
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    /**
     * Create a new authentication logout event instance.
     */
    public function __construct(
        public User $user
    ) {
    }

    /**
     * Get the channels the event should broadcast on.
     */
    public function broadcastOn(): PresenceChannel
    {
        return new PresenceChannel('inside.users');
    }
}
