<?php

namespace Inside\Authentication\Console;

use Illuminate\Console\Command;
use Inside\Authentication\Models\Token;

class UsersLogoutCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'inside:authentication:logout';

    /**
     * @var string
     */
    protected $description = 'Clean up all tokens and disconnect users';

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'inside:authentication:logout {--email=}';

    /**
     * @inheritDoc
     */
    public function handle(): void
    {
        $email = $this->option('email');

        Token::where('authenticator', '<>', 'cli')
            ->when($email, fn ($query) => $query->whereHas('user', fn ($subquery) => $subquery->where('email', $email)))
            ->delete();
    }
}
