<?php

namespace Inside\Authentication\Console;

use Illuminate\Support\Facades\Hash;
use Inside\Authentication\Models\ApplicationClient;
use Inside\Console\Command;
use Inside\Support\Str;

class GenerateApplicationClientResetCommand extends Command
{
    protected $signature = 'inside:authentication:client:reset {application}';

    protected $description = 'Réinitialisation de la clé secrète d\'une application client JWT';

    public function handle(): void
    {
        /** @var string $application */
        $application = $this->argument('application');
        $this->line("Réinitialisation de la clé secrète de l'application {$application}");
        $client = ApplicationClient::where('name', $application)->first();
        if ($client === null) {
            $this->error('L\'application  {$application} n\'existe pas');

            return;
        }
        if (false === $this->confirm('Etes-vous sur de vouloir continuer ? Cela invalidera l\'ancienne clé secrète?')) {
            return;
        }
        $secret = Str::random(64);
        $client->secret = Hash::make($secret);
        $client->save();
        $this->writeln(
            "La clé secrète de l\'application <fg=cyan>{$application}</fg=cyan> a bien été réinitialisée. La clé secrète d'identification est désormais "
        );
        $this->writeln("<fg=green>{$secret}</fg=green>");
    }
}
