<?php

namespace Inside\Authentication;

use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Contracts\Support\Jsonable;
use Inside\Authentication\Models\Token;

class AccessToken implements Arrayable, Jsonable
{
    /**
     * token instance
     */
    public Token $accessToken;

    /**
     * Text version of the token
     */
    public string $plainTextToken;

    /**
     * AccessToken constructor.
     *
     * @param Token $accessToken
     * @param string  $plainTextToken
     */
    public function __construct(Token $accessToken, string $plainTextToken)
    {
        $this->accessToken = $accessToken;
        $this->plainTextToken = $plainTextToken;
    }

    /**
     * @param int $options
     * @return string|false
     */
    public function toJson($options = 0): bool|string
    {
        return json_encode($this->toArray(), $options);
    }

    public function toArray(): array
    {
        return [
            'accessToken'    => $this->accessToken,
            'plainTextToken' => $this->plainTextToken,
        ];
    }
}
