<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Authentication\Facades\InsideSessionLifetime;
use Inside\Settings\Facades\Settings;
use Inside\Settings\Models\Setting;

final class AlterSessionLifetimeToMinutes extends Migration
{
    public function up(): void
    {
        Setting::updateOrCreate(
            ['key' => 'inside_session_lifetime', 'group' => 'loginpage'],
            ['value' => intval(config('session.lifetime'))]
        );

        Setting::updateOrCreate(
            ['key' => 'inside_session_longer_lifetime', 'group' => 'loginpage'],
            ['value' => intval(config('session.longer_lifetime'))]
        );

        Setting::updateOrCreate(
            ['key' => 'inside_session_sso_lifetime', 'group' => 'loginpage'],
            ['value' => intval(config('session.sso_lifetime'))]
        );
    }
}
